$Ontext
This codes tests the new idea of using volume treated as a variable and getting
rid of the binary variables. This way the industry can decide to treat different
volumes of waste using different technologies and trade simultaneously to achieve
reduction targets.

The code solves the stochastic programming formulation of the mercury trading problem.
It solves the mercury trading problem using a two stage approach.
The problem is divided as follows:
- The first stage decision variables are volumes treated by each industry using each
   technology. Once these are decided, binary parameters reflecting the selection of
   a technology (for non-zero volume) are decided and used for second stage problem.
   The objective is minimization of the
  compliance cost by considering linear approximations of the cost functions.
- The second stage variables are the technology design decisions. These decisions
  are taken to minimize cost in the presence of extensive nonlinear cost functions.
  Some parameters in these nonlinear relatioships are considered as uncertain.
Note:The question is: Can you actually optimize the design? Right now, all the design
equations are equalities and hence it is the direct computation of the nonlinear
cost.

The choice is between a set of possible treatment options and the option of
trading.
The details of the three treatement technologies are:
1. Coagulation and Filteration
2. Activated Carbon
3. Ion Exchange
The code takes the value of TMDL and does the rest of the calculations automatically.
The health care cost is calculated after the optimization problem solution.

Declaration of units:
TMDL = Kg/year
HSC = nano grams per liter (parts per trillion)
TC= $ per 1000 Gallons
q = nano grams per liter
water_intake = liters per day per person
fish_intake = Kg per person per day
safe_Hg = mg/Kg
LC50 = micro grams per liter


$Offdigit
$Offlisting
$Offsymxref
$Offsymlist
$Offuelxref
$Offuellist
$Offupper

options Limcol=0;
options Limrow=0;
options profile=0;
option sysout=off;
option solprint=on;
$offtext

*
* Option to govern the display of values in the results.
*
option decimals = 5;
*===============================================================================
*
* Set declarations related to model
*
Sets i Number of industries /1*29/
* Restricting the size of the problem by including only a subset of industries in the problem
     j Number of treatment options /1*3/
     alias(i,k);
*
* Set declarations related to the code
*
Sets s1 Set for the declaration of sub-problem matrices /1*2/
     s2 Set for the declaration of sub-problem matrices /1*7/
     n Maximum number of possible iterations /1*10/
     m Number of samples /1*10/;
*===============================================================================
*===============================================================================
*
* Declaration of model related parameters
*
Parameter TMDLMean Total Maximum Daily Load - Mean
          TMDL TMDL vector for the given samples /32/
          HSC Highest Segment Concentration (ng per lit) /5.0/
          CAL Current Annual Load (Kilograms per year) /58.8/

          r trading ratio /1.1/
*          F trading transaction cost (dollars per Kg) /400000000/
          F trading transaction cost (dollars per Kg) /1500000/
          TC Plant costs for the three technologies /1 0.953E-5,2 1.334E-5,3 0.882E-5/

*          TC Plant costs for the three technologies (in $ per 1000 gallons) /1 1.0,2 1.55,3 0.65/
*   Trying new values derived from nonlinear averages
*          TC Plant costs for the three technologies (in $ per 1000 gallons) /1 0.953, 2 1.334, 3 0.882/
          q Reductions possible by the treatment technologies (in ng per liter)/1 2,2 3,3 1/

          water_intake Intake of water by an average individual per day in liters /2.0/
          fish_intake Intake of fish food by an everage individual in kg per day /0.0175/
          safe_hg Safe concentration of Hg in fishes in mg per kg /0.4/
          LC50 The LC50 value of HG (taken from fishes) in micrograms per liter /350/

          Compensation Compensation for each dead person in dollar /3000000/
          population total population consuming the water /10000/;
*
* Declaration of scalars in the problem
*
scalar k1 conversion from gallons to liters /3.7845/
       k2 scalar used as a counter
       U Big value for the either-or constraint modeling /10/;
*
* Declaration of parameters in the problem for intermediate calculations
*
Parameter Cost cost incurred by each industry due to waste treatment setup
          CostTechnology The cost incurred by each industry due to technology implementation only
          CostTotal The total overall cost incurred which is to be minimized
          CostCombined Combined cost including the technology cost and health care cost
          CostHealth The actual health cost incurred due to the pollutant discharge
          ReductionTarget Desired reduction in grams per year for the individual industries
          ReductionTargetTotal The total targetted reduction from all the industries
          ReductionFinal Final reduction in the discharge achieved by each industry after optimization
          ReductionFinalTotal The final combined reduction achieved by all the industries
          ReductionTechnology The final reduction achieved by each industry due to technology implementation only
          WQS Water Quality Standard (ng per lit)
          Mortality The number of people dying due to the contamination

          TechnologyReductionCost Reduction cost per unit mass of the pollutant for each technology ($ per grams)

*          NonlinearTechCost The nonlinear technology implementation cost for each industry

          CostTechSolution cost incurred by each industry for each technology due to waste treatment setup
          CostTechSolutionPS cost incurred by each industry due to waste treatment setup
          CostTechSolutionTotal The total overall cost incurred which is to be minimized
          CostTechSolutionMax The maximum value for the nonlinear technology implementation costs for each industry from all samples;
*
* Declaration of parameters to store results
*
Parameters  TotalTrading Total amount of mercury traded

            OptObjectiveSet Vector to store the Optimality results

            bSet Stores the binary decision for each sample
            Saving Saving through trading implementation
            Results Summary of cost related values;
*
* Declaration of parameters related to two stage problem solution
*
scalar iter iteration count
       FirstIteration First iteration indicator - To control the solution of feasibility problem
       k3 Count for the solution of both subproblems for each sample
       epsilon Scalar to terminate the feasibility cut generation;

epsilon = 1E-5;

parameter
         WOpt Matrix for the second stage problem- Optimality Cut
         TOpt The T matrix in the generation of optimality cut
         hOpt The h vector for the second stage problem solution - optimality cut
         G2 Parameter used to generate cuts after second stage is solved
         G1 Parameter used to generate cuts after second stage is solved
         E1 Temporay Parameter used to generate cuts after second stage is solved
         E2 Temporary Parameter used to generate cuts after second stage is solved
         E1Set Parameter used to store optimality cut data for each sample
         E2Set Parameter used to store optimality cut data for each sample
         ThetaExact Variable for comparison with thetal.l
         a Temporary storage parameter of the first stage decision values
         objective_dual stores the objective value of dual solution for the various samples in the second stage

         ThetaSet Values of Theta.l
         ThetaExactSet Values of ThetaExact;
*===============================================================================
*
* Declaration of the industry data
*
Table Data Data related to the industries
*Data(i,1) is the total volumetric discharge in MGD
*Data(i,2) is the current discharge concentration in nanograms/liter
*Data(i,3) is the available capital with the industry in Million Dollars
         1       2       3
1        46.1    4.65    68
2        1.5     3.7     8
3        4.6     4.3     15
4        1.5     3.4     5
5        2       3.88    10
6        2.24    3.7     12
7        1.2     3.9     9
8        27      4.83    30
9        4.5     4.0     15
10       1       3.1     5
11       1       3.06    5
12       1       3.22    5
13       2       3.31    9
14       3.765   4.8     10
15       18      4.33    60
16       7.2     5.1     20
17       58.6    4.87    100
18       23      4.52    40
19       1.152   5.05    10
20       0.362   4.14    5
21       108     4.58    130
22       4.68    5.2     12
23       28.09   4.41    45
24       1.921   3.9     10
25       0.544   4.5     7
26       0.5     3.95    10
27       0.003   3.72    5
28       1.246   4.1     5
29       0.054   3.4     3;
*===============================================================================
*
* Calcuation of the derived parameters:
* Reduction cost for each technology in $ per gram
*
TechnologyReductionCost(j)=0.001*TC(j)/(10**(-12)*k1*q(j));
*
* Water quality standard in nano grams per liter
*
WQS=(HSC/CAL)*TMDL;
*
* Reduction target for each industry based on the current discharge concentration in grams per year.
* And total Targeted reduction
*
ReductionTarget(i)=((Data(i,'2')-WQS)*10**(-12))*Data(i,'1')*k1*10**(6)*365;
ReductionTargetTotal=sum(i,ReductionTarget(i));
*===============================================================================
* Declaration of parameters for the process models: The equations are written later
* The parameters that are to be sampled are sampled at this stage.
*===============================================================================
* Model for Coagulation and filtration (CF) process
*===============================================================================
* Note: The model implemented here is only for the filtration process. It does not
* include the model for the coagulation process. The filtration model is for
* a general water treatment process.
*
* Basic Parameters for the process
*
Parameter
*
* Process Input
*
CF_PlantAvailability Plant availability in percent /100/
CF_PlantOpTime Plant operation time in percent /100/
CF_MembraneModuleEqCost Membrane module equipment cost in $ /370000/
* This value is changed from the spreadsheet (original value 27000)
CF_ModularFlowRate Modular system flow rate in GMP /600/
CF_NoOfMembranesPerModule Number of membranes per module /90/
CF_PumpEfficiency Pump efficiency in percent /80/
CF_MotorEfficiency Motor efficiency in percent /93/
CF_DesignFeedPressure Design feed pressure in PSI /30/
CF_BackflushPressure Backflush pressure in PSI /29/
CF_BackwashInterval Backwash interval in minutes /15/
CF_BackwashBackflushDuration Backwash and backflush duration /0.1/
* Uncertain parameters in this catagory
CF_CostPerMembraneMean Mean cost per membrane in $ /650/
* Sampled parameters are stored in a parameter used later in the loop (based on the mean value defined above)
CF_CostPerMembraneSet Cost per membrane in $ - To be sampled
* Sampled parameter value from the set defined above
CF_CostPerMembrane Cost per membrane in $
*
* Operations and Maintenance cost Input
*
CF_DesignDosage Design dosage in mg per liter /200/
CF_NaOClSpecGravity Sodium Hypochlorite specific gravity /1.168/
CF_NaOClConc Sodium Hypochlorite solution concentration in percent /12/
CF_StaffDays Staff days /5/
CF_LaborRate Labor rate per unit hour (salary and benefits) in $ per hours /36.2/
CF_AmortizationTime Amortization time in years /20/
CF_InterestRate Interest rate in percent /8/
CF_BuildingAreaCost Building area cost in $ per m2 /1076/
CF_PerModuleInstallationCost Per Module Installation Cost /70000/
* Uncertain parameters in this catagory
CF_ElectricityRateMean Mean electricity rate (cost) in $ per kWh /0.095/
CF_NaOClCostMean Mean Sodium hypochlorite cost in $ per liter for 12% solution /0.43/
CF_MembraneLifeMean Mean membrane life in years /5/
* Sampled parameters are stored in a parameter used later in the loop (based on the mean value defined above)
CF_ElectricityRateSet Mean electricity rate (cost) in $ per kWh - To be sampled
CF_NaOClCostSet Mean Sodium hypochlorite cost in $ per liter for 12% solution - To be sampled
CF_MembraneLifeSet Mean Membrane life in years - To be sampled
* Sampled parameter value from the set defined above
CF_ElectricityRate Mean electricity rate (cost) in $ per kWh
CF_NaOClCost Mean Sodium hypochlorite cost in $ per liter for 12% solution
CF_MembraneLife Mean Membrane life in years;
*
* Sampling of the uncertain parameters: Using uniform sampling available in GAMS
*
CF_CostPerMembraneSet(m)=uniform[CF_CostPerMembraneMean*0.8, CF_CostPerMembraneMean*1.2];
CF_ElectricityRateSet(m)=uniform[CF_ElectricityRateMean*0.8, CF_ElectricityRateMean*1.2];
CF_NaOClCostSet(m)=uniform[CF_NaOClCostMean*0.8, CF_NaOClCostMean*1.2];
CF_MembraneLifeSet(m)=uniform[CF_MembraneLifeMean*0.8, CF_MembraneLifeMean*1.2];
*
* Computed Parameters for the process
*
Parameter CF_RecoveryRate Recovery rate for the water flow in percent;

Positive Variables
CF_NoOfModules Number of modules
CF_BackwashFlow Backwash flow
*CF_RecoveryRate Recovery rate for the water flow in percent
CF_FeedPumpHP Feed pump horsepower
CF_FeedPumpPower Feed pump power requirement in kWh
CF_BackflushPower Backflush power requirement in kWh
CF_MFF Microfiltration feed flow in liters per sec
CF_NoOfMembranes Number of membranes used
CF_BuildingArea Building area for the process implementation
* Direct and indirect construction costs
CF_MembraneModuleCost Membrane module cost
CF_BuildingCost Building cost - based on the building area
CF_InstallationCost Installation cost for the process
CF_MiscCost Miscellaneous cost (taken as 5% of the module cost)
CF_PlantPipingCost Plant piping cost (taken as 5% of the module and misc cost)
CF_EngineeringCost Engineering cost (taken as 10% of the module and misc cost)
CF_DirectCapitalCost Total direct capital cost
CF_ConstructionInterest Expense on interest during construction (taken as 6% of total direct capital cost)
CF_Contingencies Contingencies (taken as 20% of total direct capital cost)
CF_ProjectManagement Fees and project management (taken as 10% of total direct capital cost)
CF_WorkingCapital Working capital (taken as 4% of total direct capital cost)
CF_IndirectCapitalCost Total indirect capital cost
CF_TotalConstructionCost Total (direct and indirect) construction cost
* Operating and maintenance costs
CF_ElectricityCost Electricity cost for the implementation of the process
CF_LaborCost Labor cost for the implementation of the process
CF_ChemicalCost Chemical cost for the process
CF_MembraneReplacementCost Membrane replacement cost for the process
CF_CleaningChemicalCost Cleaning chemical (NaOCl) cost
CF_Repairs Repairs replacement and misc cost (taken as 2% of the direct capital cost)
CF_TotalOMCost Total operating and maintenance cost

CF_CapitalRecovery Capital recovery - calculate from the total captical cost
CF_AnnualCost Annual cost depending on the Capital recovery and OM cost;
*
*===============================================================================
* Model for Granular Activated Carbon (GAC) Process
*===============================================================================
*
* Basic Parameters for the process
*
Parameter GAC_CapitalCostK1Mean Mean of constant 1 for the capital cost calculation /1948.8/
          GAC_CapitalCostK2 Constant 2 for the capital cost calculation /0.2569/
          GAC_OMCostK1Mean Mean of constant 1 for the operating and maintenance cost calculation /225.42/
          GAC_OMCostK2 Constant 2 for the operating and maintenance cost calculation /0.1692/
* Sampled parameters are stored in a parameter used later in the loop (based on the mean value defined above)
          GAC_CapitalCostK1Set Constant 1 for the capital cost calculation - To be sampled
          GAC_OMCostK1Set Constant 1 for the operating and maintenance cost calculation - To be sampled
* Sampled parameter value from the set defined above
          GAC_CapitalCostK1 Constant 1 for the capital cost calculation
          GAC_OMCostK1 Constant 1 for the operating and maintenance cost calculation ;
*
* Sampling of the uncertain parameters: Using uniform sampling available in GAMS
*
GAC_CapitalCostK1Set(m)=uniform[GAC_CapitalCostK1Mean*0.8, GAC_CapitalCostK1Mean*1.2];
GAC_OMCostK1Set(m)=uniform[GAC_OMCostK1Mean*0.8, GAC_OMCostK1Mean*1.2];
*
* Computed Parameters for the process
*
Positive Variables
GAC_CapitalCost Capital cost for the activated carbon process
GAC_OMCost Operational and maintenance cost for the activated carbon process
GAC_TotalCost Total cost for the activated carbon process implementation;
*
*===============================================================================
* Model for Ion Exchange Process
*===============================================================================
*
* Basic Parameters for the process
*
Parameters
IX_CationEqv Equivalents per liter of cations /0.00362/
IX_AnionEqv Equivalents per liter of anions /0.00737/
IX_ResinCationEqv Cation Equivalents per liter of resin /20/
IX_ResinAnionEqv Anion Equivalents per liter of resin /11/
IX_DesiredRunCycle Desired run cycle in days /1/
IX_ServiceFlowRate Service flow rate (lit per hour per Lit of resin) /20/
IX_ResinExpCoeff Resin expansion coefficient /2/
IX_VesselAspectRatio Aspect ratio for the vessel /4/
IX_CostFactor Cost factor for the operating pressure /2/
IX_NaClMassPerResin Mass of NaCl per unit volume of resin in Kg per m3 /150/
IX_NaClCost Cost of NaCl per kg /0.02/
IX_NaClConc Concentration of the regeneration chemical in percent /10/
IX_PlantAailabilityFactor Plant availability due to down time /1/
IX_PlannedOpTimePerDay Planned operation time per day /1/
* Uncertain parameters in this catagory
IX_ResinPriceMean Mean nominal resin price in $ per m3 /1607/
IX_CostSlopeMean Mean slope for the logarithmic equation for the vessel cost calculation /0.562/
IX_CostInterceptMean Mean intercept for the logarithmic equation for the vessel cost calculation /3.446/
* Sampled parameters are stored in a parameter used later in the loop (based on the mean value defined above)
IX_ResinPriceSet Mean nominal resin price in $ per m3
IX_CostSlopeSet Mean slope for the logarithmic equation for the vessel cost calculation
IX_CostInterceptSet Mean intercept for the logarithmic equation for the vessel cost calculation
* Sampled parameter value from the set defined above
IX_ResinPrice Mean nominal resin price in $ per m3
IX_CostSlope Mean slope for the logarithmic equation for the vessel cost calculation
IX_CostIntercept Mean intercept for the logarithmic equation for the vessel cost calculation;
*
* Sampling of the uncertain parameters
*
IX_ResinPriceSet(m)=uniform[IX_ResinPriceMean*0.8, IX_ResinPriceMean*1.2];
IX_CostSlopeSet(m)=uniform[IX_CostSlopeMean*0.8, IX_CostSlopeMean*1.2];
IX_CostInterceptSet(m)=uniform[IX_CostInterceptMean*0.8, IX_CostInterceptMean*1.2];
*
* Computed Parameters for the process
*
Positive variables
IX_MinResinVolume Minimum volume of the medium in m3
IX_MinVolExhaustionTime Minimum volume exhaustion time in days
IX_RunCycleResin Resin for the desired run cycle in m3
IX_ExhaustionTimeResinVolume Resin volume in m3 for the minimum exhaustion time
IX_VesselVolume Total vessel volume in m3
IX_ResinCost Total resin cost (in $ per day -- need to check)
IX_BedArea Bed area for the vessel in m2
IX_TankTotalCost Total Tank cost in $
IX_NaClReq NaCl requirement in Kg per day
IX_TotalChemCost Total chemical cost per year
IX_RegFluidReq Regeneration fluid requirement
IX_StorageTankCost Storage tank cost
IX_ConstructionCost Construction cost
IX_OMCost Operating and maintenance cost
IX_TotalCost Total cost for the implementation of ion exchange process for each industry;
* This cost is the sum of the construction and vessel cost which are one time expenses
* and annual operating-maintenance cost and the annual resin cost.
*===============================================================================

*===============================================================================
*
* Declaration of the model variables
*
* Technology only problem solution decision variables
*
Variable Tobj Objective function for the technoogy only problem;
*
* First stage decision variable
*
Parameter b binary parameter specifying the process selection based on first stage decision variables;
Positive Variable t Variable deciding the amount of mercury traded between various industries;
Variable   Theta Linear approximation of the recourse function
         MasterObjective Objective function of the master problem;
Positive Variable Volume volume of waste treated by each industry using each technology (defined over i and j);

*
* Second stage decision variable
*
Variables SubObjective Objective function of the second stage sub-problem
          WQS_final Final water standard achieved after reduction;

*===============================================================================
* Describing all the model computations as equations rather than simple parameter
* computations. The computed parameters in the model are converted into variables.
*===============================================================================
*
* Desired flow rate in L/sec. The original unit is MGD. And the emperical equations
* use the units L/sec. So instead of using a conversion factor in all equations,
* generating a new parameter in the desired unit for the flow.
*
Positive Variable DFR Desired flow rate for the industry in liters per sec;
Equation DFREq;
DFREq(i,j)..     DFR(i,j) =e= Volume(i,j)*10**(6)*k1/86400 ;
*===============================================================================
* Model for Coagulation and filtration (CF) process
*===============================================================================
Equations CF01, CF03, CF04, CF05, CF06, CF07, CF08, CF09, CF10, CF11, CF12,
          CF13, CF14, CF15, CF16, CF17, CF18, CF19, CF20, CF21, CF22, CF23, CF24, CF25,
          CF26, CF27, CF28, CF29, CF30, CF31;
* Removing the round function to avoid discontinuity in the model
CF01(i)..                CF_NoOfModules(i) =e= (Volume(i,'1')*10**6/(24*60*CF_ModularFlowRate)) ;

* An approximation is used in this equation. The original equation had division by DFR which might be a problem.
* So here, that part is solved using previous equation so that now there is only parameter part remaining.
* This approximation is possible only because we have removed the round function from the previous equation.
*CF02(i)..                CF_RecoveryRate(i) =e= 100-(24*3600/(CF_BackwashInterval*60))*(CF_BackwashBackflushDuration*60)
*                                      * (CF_ModularFlowRate*k1/60)*(1/(24*60*CF_ModularFlowRate*k1))*100 ;

* Declaring recovery rate as a parameter instead of a variable
             CF_RecoveryRate(i) = 100-(24*3600/(CF_BackwashInterval*60))*(CF_BackwashBackflushDuration*60)
                                      * (CF_ModularFlowRate*k1/60)*(1/(24*60*CF_ModularFlowRate*k1))*100 ;

CF03(i)..                CF_MFF(i) =e= (DFR(i,'1')/(CF_RecoveryRate(i)/100));

CF04(i)..                CF_BackwashFlow(i) =e= (CF_MFF(i)-DFR(i,'1'));

CF05(i)..                CF_FeedPumpHP(i) =e= (CF_MFF(i)*60/k1)*(2.31*CF_DesignFeedPressure)/(3960*CF_PumpEfficiency/100);

CF06(i)..                CF_FeedPumpPower(i) =e= CF_FeedPumpHP(i)*365*24*0.746 ;
*                Note: The original equation has the term 'planned operation time per day' and
*                'plant availability due to downtime'.
*                 The values are 1 and hence it is ignored in the equation above.

CF07(i)..                CF_BackflushPower(i) =e= CF_FeedPumpHP(i)*((CF_BackwashBackflushDuration*60*86400/900)/3600) * 365*0.745 ;

CF08(i)..                CF_NoOfMembranes(i) =e= CF_NoOfModules(i) * CF_NoOfMembranesPerModule ;

CF09(i)..                CF_BuildingArea(i) =e= (DFR(i,'1')*86400/1000) * (1.227244/100) ;
*
*                Computation of the Direct Capital Cost
*
CF10(i)..                CF_MembraneModuleCost(i) =e= CF_MembraneModuleEqCost * CF_NoOfModules(i) ;

CF11(i)..                 CF_BuildingCost(i) =e= CF_BuildingAreaCost * CF_BuildingArea(i) ;

CF12(i)..                 CF_InstallationCost(i) =e= CF_PerModuleInstallationCost * CF_NoOfModules(i) ;

CF13(i)..                 CF_MiscCost(i) =e=  CF_MembraneModuleCost(i)*0.05 ;

CF14(i)..                 CF_PlantPipingCost(i) =e= (CF_MembraneModuleCost(i)+CF_MiscCost(i))*0.05 ;

CF15(i)..                 CF_EngineeringCost(i) =e= (CF_MembraneModuleCost(i)+CF_MiscCost(i))*0.10 ;

CF16(i)..                 CF_DirectCapitalCost(i) =e= CF_MembraneModuleCost(i) + CF_BuildingCost(i) + CF_InstallationCost(i)
                                    + CF_MiscCost(i) + CF_PlantPipingCost(i) + CF_EngineeringCost(i) ;
*
*                Computation of the indirect Capital Cost
*
CF17(i)..                 CF_ConstructionInterest(i) =e= CF_DirectCapitalCost(i) * 0.06 ;

CF18(i)..                 CF_Contingencies(i) =e= CF_DirectCapitalCost(i) * 0.20 ;

CF19(i)..                 CF_ProjectManagement(i) =e= CF_DirectCapitalCost(i) * 0.10 ;

CF20(i)..                 CF_WorkingCapital(i) =e= CF_DirectCapitalCost(i) * 0.04 ;

CF21(i)..                 CF_IndirectCapitalCost(i) =e= CF_ConstructionInterest(i) + CF_Contingencies(i)
                                          + CF_ProjectManagement(i) + CF_WorkingCapital(i) ;

CF22(i)..                 CF_TotalConstructionCost(i) =e= CF_DirectCapitalCost(i) + CF_IndirectCapitalCost(i) ;

*
*                Operations and Maintenance cost estimates
*
CF23(i)..                 CF_ElectricityCost(i) =e= (CF_FeedPumpPower(i)+CF_BackflushPower(i))* CF_ElectricityRate ;

CF24(i)..                 CF_LaborCost(i) =e=  CF_StaffDays * 365 * 8 * CF_LaborRate  ;
*                Note: The original equation has the term 'planned operation time per day' at the end.
*                The value is 1 and hence it is ignored in the equation above.
*                Also, the rounding operation to the third place is ignored since it is not
*                necessary to have this as a integer variable.

CF25(i)..                 CF_ChemicalCost(i) =e= (0.0025 * (DFR(i,'1')*86400/k1) - 333.333) * 2 * CF_NaOClCost ;

CF26(i)..                 CF_MembraneReplacementCost(i) =e=  CF_NoOfMembranes(i) * CF_CostPerMembrane / CF_MembraneLife ;
*                Note: The membrane replacement cost is taken by considering that membrane life is
*                5 years and assuming uniform degradation of the membrane every year.

CF27(i)..                 CF_CleaningChemicalCost(i) =e= (0.0005 * (DFR(i,'1')*86400/k1)+66.667) * 2 * CF_NaOClCost ;

CF28(i)..                 CF_Repairs(i) =e= CF_DirectCapitalCost(i) * 0.02 ;

CF29(i)..                 CF_TotalOMCost(i) =e= CF_ElectricityCost(i) + CF_LaborCost(i) +  CF_ChemicalCost(i)
                                 + CF_MembraneReplacementCost(i) + CF_CleaningChemicalCost(i) + CF_Repairs(i) ;

CF30(i)..                 CF_CapitalRecovery(i) =e= CF_TotalConstructionCost(i)
                                 *(((CF_InterestRate/100)*(1+CF_InterestRate/100)**CF_AmortizationTime)/((1+CF_InterestRate/100)**CF_AmortizationTime-1)) ;

CF31(i)..                 CF_AnnualCost(i) =e= (CF_CapitalRecovery(i) + CF_TotalOMCost(i))*2 ;

*===============================================================================
* Model for Granular Activated Carbon (GAC) Process
*===============================================================================
Equations GAC01, GAC02, GAC03;

GAC01(i)..                 GAC_CapitalCost(i) =e= 1948.8 * (Volume(i,'2') * 3785.4118)**(1-0.2569) ;
GAC02(i)..                 GAC_OMCost(i)      =e= 225.42 * (Volume(i,'2') * 3785.4118)**(1-0.1692) ;
* Note: The constant in these equations multiplying the flow parameter is to
* convert the flow rate from MGD to m3/day.
GAC03(i)..                 GAC_TotalCost(i) =e= GAC_CapitalCost(i) + GAC_OMCost(i) ;
*===============================================================================
* Model for Ion Exchange Process
*===============================================================================
*
* Computation of the Ion Exchange process parameters
*
Equations IX01,IX02,IX04,IX05,IX06,IX07,IX08,IX09,IX10,IX11,IX12,IX13,IX14,IX15;

IX01(i)..                 IX_MinResinVolume(i) =e= (DFR(i,'3')*3600/(IX_ServiceFlowRate*1000));
* The constants are to convert the units.

IX02(i)..  IX_MinVolExhaustionTime(i) =e= IX_ResinCationEqv*3600/(IX_ServiceFlowRate*IX_CationEqv*86400);
* Note: The formula is different in the document and spreadsheet! Need to clarify.

**** Additional if condition as given in the spreadsheet and the document
*IX03(i)$(IX_MinVolExhaustionTime(i)>IX_DesiredRunCycle).. IX_ExhaustionTimeResinVolume(i) =e= IX_MinResinVolume(i) ;
*IX04(i)$(IX_MinVolExhaustionTime(i)<=IX_DesiredRunCycle)..   IX_ExhaustionTimeResinVolume(i)
*                            =e= IX_DesiredRunCycle*DFR(i,'3')*86400*(IX_CationEqv)/(1000*(IX_ResinCationEqv));

IX04(i)..   IX_ExhaustionTimeResinVolume(i)
                            =e= IX_DesiredRunCycle*DFR(i,'3')*86400*(IX_CationEqv)/(1000*(IX_ResinCationEqv));

IX05(i)..                 IX_VesselVolume(i)  =e= IX_ExhaustionTimeResinVolume(i) * IX_ResinExpCoeff ;

IX06(i)..                 IX_ResinCost(i)   =e= IX_ExhaustionTimeResinVolume(i) * IX_ResinPrice ;
* Note: The resin cost is per day -- probably.

IX07(i)..                 IX_TankTotalCost(i) =e= 10**(IX_CostIntercept+IX_CostSlope*log10(IX_VesselVolume(i)+epsilon))
                                         * IX_CostFactor ;
* Note: This calculation is different in the document and excel sheet. This equation
*       is taken from the excel sheet.
*
* Regeneration requirements
*
IX08(i)..                 IX_NaClReq(i) =e= IX_ExhaustionTimeResinVolume(i) * IX_NaClMassPerResin ;

IX09(i)..                 IX_RegFluidReq(i) =e= IX_NaClReq(i)/((IX_NaClConc/100)*1000);

IX10(i)..                 IX_TotalChemCost(i) =e=  IX_NaClReq(i) *  IX_NaClCost
                                         * (365*IX_PlantAailabilityFactor*IX_PlannedOpTimePerDay/(IX_DesiredRunCycle+1)) ;

* Storage tank cost according to the spreadsheet
IX11(i)..                 IX_StorageTankCost(i) =e=0.25*1000* IX_RegFluidReq(i);
*
* Regeneration and backwashing pump
*
IX12(i)..                 IX_BedArea(i) =e= (3.14/4)*((4*IX_VesselVolume(i))/(IX_VesselAspectRatio*3.14))**(2/3) ;

IX13(i)..                 IX_ConstructionCost(i) =e= (36000 + 1254.21* IX_BedArea(i) - 0.1212*IX_BedArea(i)**2) ;
* Note: The construction cost is one time -- probably.

IX14(i)..                 IX_OMCost(i) =e= (73.3 * IX_BedArea(i)**(0.75) + 2200) ;
* Note: The operating and maintenance cost is annual.

IX15(i)..                 IX_TotalCost(i) =e= IX_ConstructionCost(i)  + IX_StorageTankCost(i)
                                + IX_TankTotalCost(i) + IX_ResinCost(i)*24 + IX_TotalChemCost(i)
                               + IX_OMCost(i) ;
*===============================================================================
Positive Variable NonlinearTechCost;
Equations NonlinearTechCost01, NonlinearTechCost02, NonlinearTechCost03;
NonlinearTechCost01(i)..  NonlinearTechCost(i,'1') =e= CF_AnnualCost(i)*1E-5;
NonlinearTechCost02(i)..  NonlinearTechCost(i,'2') =e= GAC_TotalCost(i)*1E-5;
NonlinearTechCost03(i)..  NonlinearTechCost(i,'3') =e= IX_TotalCost(i)*1E-5;
*===============================================================================
*
* First Technology only model is solved to generate constraints for the trading problem.
* The constraint states that no industry should be required to spend more as a results
* of trading.
*
* Definig the Technology only problem
*
Equations Tobjective
          Tc1
          Tc2;
*
* Objective: Minimization of the compliance cost. 10**(-3) factor from TC(j) and
* 10**(6) factor from Data(i,1) result in 1000.
*
Tobjective.. Tobj =e= sum((i,j), NonlinearTechCost(i,j));
*
* Restriction on the number of technologies that can be implemented (varies from 1-3)
*
Tc1(i)..  sum(j,Volume(i,j)) =l= Data(i,'1');
*
* The reduction achieved should be atleast equal to the desired reduction.
* The reduction constraint is multiplied by 1000 on both sides to avoid
* numerical errors arising due to small values. In LHS, 10**(-12) factor for q(j)
* and 10**6 factor for Data(i,1) result in 10**(-6).
*
Tc2(i).. 10**(-6)*k1*365*sum(j,q(j)*Volume(i,j)) =g= ReductionTarget(i);
*
* Use a single value of reduction (probably the mean or worst value) for this problem solution
*
Model TechProblem /Tobjective, Tc1, Tc2, DFREq,
          CF01, CF03, CF04, CF05, CF06, CF07, CF08, CF09, CF10, CF11, CF12,
          CF13, CF14, CF15, CF16, CF17, CF18, CF19, CF20, CF21, CF22, CF23, CF24, CF25,
          CF26, CF27, CF28, CF29, CF30, CF31,GAC01, GAC02, GAC03,
          IX01,IX02,IX04,IX05,IX06,IX07,IX08,IX09,IX10,IX11,IX12,IX13,IX14,IX15,
          NonlinearTechCost01, NonlinearTechCost02, NonlinearTechCost03/;
*===============================================================================
*
* Declaration of the master problem: The the problem is the simultaneous technology
* and trading selection decisions.
*
Equations Mobj Objective function for the master problem
          Mc1 Limitation on the number of technologies per industry
          Mc2 No trading within the industry
          Mc3 Constrain on the objective based on linear approximation
          Mc4 Constraint to satisfy the minimum reduction requirement
          Mc5 Constraint not to exceed the Tech only reduction cost
          Mc6 Lower bound on the reduction
          Mc7 Constraint for the first master problem solution
          Mc8 Optimality cut for the first stage problem
          Mc9 Triel constraint;
*
* The objective function is the sum of the reduction cost (implementation and
* trading cost). Since trading cost is not really incurred for the watershed taken
* together, the objective reflects only the technology implemntation cost.
*
* In this problem, the master problem objective function is the linear approximation
* of the technology implementation costs. In the second stage problem, this linear
* approximation is refined using nonlinear and exact equations. So in that sense,
* theta is actually the total master problem objective. One idea therefore is to use
* theta as the objective function. where theta is defined through an equality constraint
* to be equal to the linear tech cost. In the first stage there is no constraint on
* theta. After the first iteration, the optimality cut is introduced in the master
* problem on theta.
*
Mobj..         MasterObjective =e= Theta;
*
* Restriction on the number of technologies that can be implemented (varies from 1-3)
*
Mc1(i)..       sum(j,Volume(i,j)) =l= Data(i,'1');
*
* No industry can trade with itself.
*
Mc2(i)..       t(i,i) =e= 0;
*
* Putting a constraint on the objective variable based on linear approximation: NEED TO CHECK IF THIS IS RIGHT
*
Mc3$(iter>1)..          Theta =g= 1000*365*sum((i,j),TC(j)*Volume(i,j));
*
* The reduction achieved should be atleast equal to the desired reduction.
* The reduction constraint is multiplied by 1000 on both sides to avoid
* numerical errors arising due to small values. In LHS, 10**(-12) factor for q(j)
* and 10**6 factor for Data(i,1) result in 10**(-6).
*
Mc4(i)..       10**(-6)*k1*365*sum(j,q(j)*Volume(i,j))+(sum(k,t(i,k))-r*sum(k,t(k,i))) =g= ReductionTarget(i);
*
* The cost incurred due to trading can not be higher than that due to technology implementation (in $ per year).
* The technology only implementation cost is the highest from given set (achieved through solution for each sample).
*
Mc5(i)..       CostTechSolutionMax(i) =g= 1000*365*sum(j,Volume(i,j)*TC(j))+F*(sum(k,t(i,k))-sum(k,t(k,i)))/1000;
*
* This constraint ensures that the minimim reduction is zero. Thus if some industry already has emission
* level below the regulation, then it is not allowed to increase its emission.
*
Mc6(i)..       10**(-6)*k1*365*sum(j,q(j)*Volume(i,j))+(sum(k,t(i,k))-r*sum(k,t(k,i))) =g= 0;
*
* Fixing the approximation of the second stage recourse function for the first iteration
*
Mc7$(iter=1).. Theta =e= -9999999;
*
* Optimality cut
*
*Mc8(n)$(ord(n)<iter)..  Theta =g= G1(n)-sum((i,j),G2(i,'1',n,j)*Volume(i,j))-sum((i,k),G2(i,'2',n,k)*t(i,k));
Mc8(n)$(ord(n)<iter)..  Theta =g= G1(n)-sum((i,j),G2(i,'1',n,j)*b(i,j))-sum((i,k),G2(i,'2',n,k)*t(i,k));
*
* Lower bound on the trading variable
*
t.lo(i,k) = 0;
Mc9(i).. Volume(i,'1') =g= 1.0;

Model MasterProblem /Mobj, Mc1, Mc2, Mc3, Mc4, Mc5, Mc6, Mc7, Mc8,  DFREq,
          CF01, CF03, CF04, CF05, CF06, CF07, CF08, CF09, CF10, CF11, CF12,
          CF13, CF14, CF15, CF16, CF17, CF18, CF19, CF20, CF21, CF22, CF23, CF24, CF25,
          CF26, CF27, CF28, CF29, CF30, CF31,GAC01, GAC02, GAC03,
          IX01,IX02,IX04,IX05,IX06,IX07,IX08,IX09,IX10,IX11,IX12,IX13,IX14,IX15/;
*===============================================================================
*
* Generation of the Matrices for second stage dual problem.
*
* In this problem, the second stage objective is the minimization of health care cost.
* This depends on the uncertain realization of actual discharge allocations (targeted reduction).
* The constraints are the equality constraints that compute the final water quality
* standard using the first stage decision variables.
* Since the first stage decisions are always second stage feasible (problem with
* complete recourse) the feasibility cut is not introduced in this problem.
*
* Matrices for the optimality cut:
*
* Initializing the Wopt matrix to 0.
*
WOpt(i,s1,k)=0;
*
* Declaring nonzero values for those corresponding to tech selection binary decisions
*
WOpt(i,'1',k)=1;
*
* Declaring hOpt which is always zero.
*
hOpt(i,s1,k)=0;
*
* Initialize the G1 and G2 matrices for the master problem: If not initialized,
* GAMS gives error on compilation
*
G1(n)=0;
G2(i,s1,n,k)=0;
*===============================================================================
* Second stage : Formulation for the Optimality Cut
*===============================================================================
* Declaration of variables and equations for the dual (second stage) problems
Positive variable pi simplex variable (one in number);
Variable OptObjective Objective function for the Optimality problem;
Equation OptObj Objective function for the optimality problem
         Optconst1 Constraint for the optimality problem;
*
* For the second stage primal problem, the objective is the pure sum of the nonlinear
* costs which are taken as the decision variables. So the coefficient matrix
* consists of just 1.
*
Optobj..   OptObjective =e= sum((i,s1,k),pi(i,s1,k)*(hOpt(i,s1,k)- TOpt(i,s1,k)*a(i,s1,k)));
Optconst1(i,s1,k).. WOpt(i,s1,k)*pi(i,s1,k) =l= 1;

Model Optimality /Optobj, Optconst1/;
*===============================================================================
* Start the Execution of various problem solutions.
*===============================================================================
*
* Parameter/Scalar initialization
*
* Iteration count
iter=1;
* Indicator of the first iteration
FirstIteration=1;
*
* The outermost loop of solving the problem iteratively will start here
*
* Initializing theta.l and ThetaExact to some arbitrary numbers so that the code
* enters the loop in the first iteration. These numbers are overwritten once the
* Master and subproblem are solved during the first iteration.
*
Theta.l=10;
ThetaExact=Theta.l+1;
*
* While loop to iteratively solve master problem and the optimality problem till
* the termination criteria is achieved.
* Sometimes, the values of theta.l and ThetaExact are practically same (and hence
* the optimal has been achieved). However there is a small difference (order of
* 10^-9, due to which the algorithm does not terminate. This is a numerical issue.
* To take care of it, a small number 'epsilon' is added in the comparison.
*
* To ensure that the technology only problem uses nonlinear costs for the problem
* solution (this will ensure that the master problem solution using the value from
* the tech-only solution in its constraint is second stage feasible), the nonlinear
* costs for each technology are calculated for each sample within this while loop.
* These costs are calculated without the inclusion of the a.l varaibles.
* The costs are then stored and used for two purposes: 1. To solve the tech only problem
* and 2. To formulate the TOpt matrix (the formulation of this matrix uses the
* first stage decision variables a.l)
*
while((Theta.l < ThetaExact-epsilon and iter<3),
*
* If it is decided that new samples are to be taken in each iteration (according
* to the internal sampling technique) then the sampling should be done here.
* If using HSS, the same samples are to be used in each iteration, then the sampling
* can be done earlier and the loop for the calculation of the NonlinearTechcost can be moved
* outside this while loop.
*

*
* Solving the optimality problem for each realization of the uncertain parameter
* and then introducing the optimality cut if needed.
*
         for (k3=1 to card(m) by 1,
*
*                Generating nonlinear costs for each process for each sample. This is later
*                used to generate the TOpt matrix and also to solve the Technology only
*                problem using the nonlinear cost values.
*                For this, the model equations for the three
*                technologies need to be solved to compute the parameter 'NonLinCost'.
*                Currently, I do not know how to call one gams code from another. Ideally,
*                it is better to have all those equations in another code which is called here
*                iteratively for each sample. That will simplify the representation.
*                However, since I do not know how to do it, currently all the equations
*                are included in this loop. Sorry for the messy representation!
*
*                Using the current sample number the appropriate value is taken from the
*                sampled set and assigned to the parameter used in the equation here.
*
                 CF_CostPerMembrane=sum(m$(ord(m)=k3),CF_CostPerMembraneSet(m));
                 CF_ElectricityRate=sum(m$(ord(m)=k3),CF_ElectricityRateSet(m));
                 CF_NaOClCost=sum(m$(ord(m)=k3),CF_NaOClCostSet(m));
                 CF_MembraneLife=sum(m$(ord(m)=k3),CF_MembraneLifeSet(m));

                 GAC_CapitalCostK1=sum(m$(ord(m)=k3),GAC_CapitalCostK1Set(m));
                 GAC_OMCostK1=sum(m$(ord(m)=k3),GAC_OMCostK1Set(m));

                 IX_ResinPrice=sum(m$(ord(m)=k3),IX_ResinPriceSet(m));
                 IX_CostSlope=sum(m$(ord(m)=k3),IX_CostSlopeSet(m));
                 IX_CostIntercept=sum(m$(ord(m)=k3),IX_CostInterceptSet(m));
*
*        Using this to solve the technology only solution.
*        Solve the Technology only problem to generate the required cut for
*        the trading problem
*
                 Options Optcr=0.001;
                 Solve TechProblem using nlp minimizing Tobj;
*
* For the final result, the binary parameter is fixed based on the volume variable
*
b(i,j)=0;
b(i,j)=1$(Volume.l(i,j)>epsilon);
*
*        Post solve computation of the Technology only implementation costs (in $/year)
*
                 CostTechSolution(i,m,j)$(ord(m)=k3) = NonlinearTechCost.l(i,j)*b(i,j);
                 CostTechSolutionPS(i,m)$(ord(m)=k3) = sum(j,CostTechSolution(i,m,j));
                 CostTechSolutionTotal(m)$(ord(m)=k3)=sum(i,CostTechSolutionPS(i,m));

         );

Display Tobj.l, Volume.l, NonlinearTechCost.l,CostTechSolution;
*
*        For the NonlinearTechCost for all the samples, select the maximum value
*        for the solution of the tech only problem
*
         CostTechSolutionMax(i) = smax(m,CostTechSolutionPS(i,m));
*
*        Solving the master problem using the technology only solution in its constraint.
*
*        MasterProblem.OptFile=1;
        Solve MasterProblem using nlp minimizing MasterObjective;
Display MasterObjective.l;

*
* The first stage decisions are stored in the temporary variable to be
* used by the second stage. This temporary variable combines the binary (b) and
* continuous decisions (t) into one matrix.
*
*
* For the final result, the binary parameter is fixed based on the volume variable
*
b(i,j)=0;
b(i,j)=1$(Volume.l(i,j)>epsilon);

         a(i,s1,j)  = 0 ;
         a(i,'1',j) = b(i,j);
         a(i,'2',k) = t.l(i,k);

         ThetaSet(n)$(ord(n)=iter)=Theta.l;
         Display a;
*
* Solving the optimality problem for each realization of the uncertain parameter
* and then introducing the optimality cut if needed.
*
         for (k3=1 to card(m) by 1,
*
*                Generating 'Topt' matrix which is on the RHS of the second stage problem.
*                For the generation of the TOpt matrix, the previously calculated
*                nonlinear technology costs and the first stage decisions are used.
*
*===============================================================================
*    Using the costs computed here for the current sample, the TOpt matrix is declared.
*===============================================================================
*                Initialize T to zero
                 TOpt(i,s1,k)=0;
*                Enter the data for the part corresponding to binary (tech selection) decisions
*                Negative sign is used to take care of the representation in standard form.
                 TOpt(i,'1','1') = -sum(m$(ord(m)=k3),CostTechSolution(i,'1',m));
                 TOpt(i,'1','2') = -sum(m$(ord(m)=k3),CostTechSolution(i,'2',m));
                 TOpt(i,'1','3') = -sum(m$(ord(m)=k3),CostTechSolution(i,'3',m));
*===============================================================================

                 Options Optcr=1E-8;
                 Solve Optimality using lp maximizing OptObjective;

                 OptObjectiveSet(m)$(ord(m)=k3)=OptObjective.l;

*                Generation of E1 and E2:
                 E1Set(m)$(ord(m)=k3)=sum((i,s1,k),pi.l(i,s1,k)*hOpt(i,s1,k));
                 E2Set(i,s1,m,k)$(ord(m)=k3)=pi.l(i,s1,k)*TOpt(i,s1,k);

         );

         E1 = sum(m,E1Set(m))/card(m);
         E2(i,s1,k) = sum(m,E2Set(i,s1,m,k))/card(m);

         G1(n)$(ord(n)=iter)=E1;
         G2(i,s1,n,k)$(ord(n)=iter)=E2(i,s1,k);

         ThetaExact = E1-sum((i,s1,k),E2(i,s1,k)*a(i,s1,k));

         ThetaExactSet(n)$(ord(n)=iter)=ThetaExact;

         iter = iter +1 ;
*
* Saving the current binary decisions
*
* bSet(i,n,j)$(ord(n)=iter)=b.l(i,j);

*
* 'While' loop ends here.
*
);

*
* For the final result, the binary parameter is fixed based on the volume variable
*
b(i,j)=0;
b(i,j)=1$(Volume.l(i,j)>epsilon);

ReductionFinal(i) = 10**(-6)*k1*365*sum(j,q(j)*Volume.l(i,j))+(sum(k,t.l(i,k))-r*sum(k,t.l(k,i)));
ReductionFinalTotal=sum(i,ReductionFinal(i));
ReductionTechnology(i)  = 10**(-6)*k1*365*sum(j,q(j)*Volume.l(i,j));

Cost(i,'1')=1000*365*sum(j,Volume.l(i,j)*TC(j))+F*(sum(k,t.l(i,k))-sum(k,t.l(k,i)))/1000;
*Cost(i,'1')=sum(j,NonlinearTechCost.l(i,j))+F*(sum(k,t.l(i,k))-sum(k,t.l(k,i)))/1000;
CostTechnology(i,'1')=1000*365*sum(j,Volume.l(i,j)*TC(j));
CostTotal = sum(i,Cost(i,'1'));

Saving(i,'1') = CostTechSolutionMax(i)-Cost(i,'1');
Results(i,'1')= CostTechSolutionMax(i);
Results(i,'2')= Cost(i,'1');
Results(i,'3')= Saving(i,'1');

option b:0;

Display ReductionTarget, ReductionFinal, ReductionTargetTotal, ReductionFinalTotal, ReductionTechnology;

Display  MasterObjective.l, iter, Volume.l, t.l, Results,CostTechSolutionMax, NonlinearTechCost.l, b;


*Display  G1, G2, ThetaSet, ThetaExactSet;
